#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSession

def Plugin( entMan ):
   import ConfigSessionPlugin.Intf # pylint: disable=import-outside-toplevel
   ConfigSessionPlugin.Intf.registerIntfEntityFilters(
      entMan, "interface/config/subintf", "Interface::SubIntfConfig" )
   subIntfHandlerDir = CliSession.registerCopyHandlerDir(
      entMan, "SubIntf", "Interface::SubIntfConfigCopyHandlerDir" )
   subIntfHandlerDir.copyHandler = ()
   subIntfHandler = subIntfHandlerDir.copyHandler
   subIntfHandler.filteredAttribute = ()
   # Filter IntfConfig attributes that are not handled by the SubIntf copy handler.
   for attrName in ConfigSessionPlugin.Intf.intfConfigFilterAttributes:
      subIntfHandler.filteredAttribute.attributeName[ attrName ] = True
   subIntfHandler.initialize()
   CliSession.registerCustomCopyHandler( entMan,
                                         "interface/config/subintf",
                                         "Interface::SubIntfConfig",
                                         subIntfHandler, direction="both" )
