#!/usr/bin/env python3
# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Logging

SYS_BOOT_RPM_DATABASE_UPDATE_ERROR = Logging.LogHandle(
              "SYS_BOOT_RPM_DATABASE_UPDATE_ERROR",
              severity=Logging.logWarning,
              fmt="System encountered an error while updating the RPM database "
                  "but will continue to boot (%s)",
              explanation="RPM database may contain data of uninstalled RPMs",
              recommendedAction=Logging.NO_ACTION_REQUIRED )
