# Copyright (c) 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac

PriorityFlowControlConfigInfo = Tac.Type( "Dcbx::PriorityFlowControlConfigInfo" )
ApplicationPriorityEntry = Tac.Type( "Dcbx::ApplicationPriorityEntry" )
ApplicationPriorityEntryKey = Tac.Type( "Dcbx::ApplicationPriorityEntry::Key" )
def ApplicationPriorityConfigInfo( *_args, **_kwargs ):
   raise Exception( "ApplicationPriorityConfigInfo is now a Tac::Entity" )

def applicationPriorityEntry( priority, sel, protocolId ):
   key = ApplicationPriorityEntryKey( sel, protocolId )
   entry = ApplicationPriorityEntry( key, priority )
   return entry

def cliSel( sel ):
   return { 'reserved0': 'unsupported (reserved 0)',
            'ether': 'ether',
            'tcpSctp': 'tcp-sctp',
            'udp': 'udp',
            'tcpSctpUdp': 'tcp-sctp-udp',
            'reserved5': 'unsupported (reserved 5)',
            'reserved6': 'unsupported (reserved 6)',
            'reserved7': 'unsupported (reserved 7)' }[ sel ]

def selFromCli( key ):
   return { 'unsupported (reserved 0)': 'reserved0',
            'ether': 'ether',
            'tcp-sctp': 'tcpSctp',
            'udp': 'udp',
            'tcp-sctp-udp': 'tcpSctpUdp',
            'unsupported (reserved 5)': 'reserved5',
            'unsupported (reserved 6)': 'reserved6',
            'unsupported (reserved 7)': 'reserved7' }[ key ]

def selValue( sel ):
   return [ 'reserved0', 'ether', 'tcpSctp', 'udp', 'tcpSctpUdp',
           'reserved5', 'reserved6', 'reserved7' ].index( sel )

applicationTable = {
      # Add more groups here:
      'iscsi': ( ( 'tcpSctp', 860 ), ( 'tcpSctp', 3260 ) )
      }

# algorithms[ cliName ] = ( id, description )
algorithms = {
   'strict-priority': ( 0, 'Strict Priority' ),
   'credit-based-shaper': ( 1, 'Credit Based Shaper' ),
   'enhanced-transmission-selection': ( 2, 'Enhanced Transmission Selection' ),
}

# algorithmNames[ id ] = cliName
algorithmNames = { algoId: cliName
                   for cliName, ( algoId, _ )
                   in algorithms.items() }
# algorithmDescriptions[ cliName ] = description
algorithmDescriptions = { cliName: f'{algoDescription} ({algoId})'
                          for cliName, ( algoId, algoDescription )
                          in algorithms.items() }
# algorithmIds[ cliName ] = id
algorithmIds = { cliName: algoId
                 for cliName, ( algoId, _ )
                 in algorithms.items() }
