# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import SysdbUtil
import Plugins

@Plugins.plugin( provides=[ 'security/aaa/config' ], requires=[] )
def Plugin( entMan ):
   SysdbUtil.addLogFacility( entMan, "AAA" )
   SysdbUtil.addLogFacility( entMan, "ACCOUNTING" )
   cfg = entMan.lookup( 'security/aaa/config' )
   # The default authentication method lists only contain local
   cfg.defaultLoginMethodList = ( "default", )
   cfg.defaultLoginMethodList.method[ 0 ] = "local"
   cfg.defaultEnableMethodList = ( "default", )
   cfg.defaultEnableMethodList.method[ 0 ] = "local"
   cfg.defaultDot1xMethodList = ( "default", )
   cfg.coaOnlyGroupList = ( "default", )
   cfg.mbaMultiGroupList = ( "default", )

   def _addType( name, method ):
      ml = cfg.authzMethod.newMember( name )
      ml.defaultMethod[ 0 ] = method
      ml = cfg.acctMethod.newMember( name )

   _addType( "exec", "none" )
   _addType( "system", "none" )
   _addType( "dot1x", "none" )
   for i in range( 0, 16 ):
      name = "command%02d" % i # pylint: disable=consider-using-f-string
      _addType( name, "none" )
