#!/usr/bin/env python3
# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from SnmpNotificationRegistrar import registerNotificationType

def Plugin( entMan ):
   notificationsBase = [
      "aristaClbPortGroupAllocatedFlowAtOrAboveThresholdWarning",
      "aristaClbPortGroupAllocatedFlowBelowThresholdWarning",
      "aristaClbPortGroupAllocatedFlowAtOrAboveLimit",
      "aristaClbPortGroupAllocatedFlowBelowLimit" ]

   notifications = zip( notificationsBase, notificationsBase )

   # If we don't strip, the show snmp notifcation output is unusable
   registerNotificationType( entMan, 'clb', notifications=notifications,
                             strip="aristaClbPortGroupAllocated" )
