# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
import Plugins
import Tac

# TODO: Need to suppress loading this when the toggle is off, as various test libs
#       expect to see nhg in the command dict.
from Toggles.EventMonToggleLib import toggleNhgEventTrackingEnabled

@Plugins.plugin( provides=[ 'eventMon/config' ] )
def Plugin( entMan ):
   if not toggleNhgEventTrackingEnabled():
      return

   config = entMan.lookup( 'eventMon/config' )

   # Should we generate the default state from a yaml tag?
   config.table.newMember( 'nhg', False )
   shaqCfg = Tac.Value( 'EventMon::ShaqConfig' )
   config.table[ 'nhg' ].eventConfig = \
      Tac.Value( 'EventMon::EventConfig', shaq=shaqCfg )
