# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import SysdbUtil
import Tac
import Plugins
import ServicePluginContext

@Plugins.plugin( provides=( 'controller/service/config', ) )
def Plugin( entMan ):
   # Register log facility
   SysdbUtil.addLogFacility( entMan, "CVX" )

   constants = Tac.Type( "Controller::Constants" )
   clusterName = constants.clusterDefaultName

   configDir = entMan.lookup( "controller/cluster/configDir" )

   clusterConfig = configDir.newConfig( clusterName )
   clusterConfig.oobConfig = ( "oobConfig", )

   clusterOobConfig = clusterConfig.oobConfig
   clusterOobConfig.sslProfileConfig = ( "sslProfileConfig", )
   clusterOobConfig.heartbeatConfig = ( "controllerHeartbeatConfig", )

   ###
   ### Controllerdb configuration
   ###
   serviceConfigDir = entMan.lookup( "controller/service/config" )
   entMan.serviceCtx_ = ServicePluginContext.ServicePluginContext( serviceConfigDir )

   # Set CVX version
   # Version 2 adds UUID
   # Version 3 adds support for secure CVX Attrlog connections
   versionWithDesc = ( ( 2, "CVXVersionConfig" ), ( 3, "CVXVersionConfig" ) )
   ServicePluginContext.addServiceInfo( entMan.serviceCtx_, "CVX", versionWithDesc )
