# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
import Plugins
import DefaultConfigPlugin.Acl

@Plugins.plugin( provides=( 'ip/helper/dhcprelay/config', ),
                 requires=( 'acl/paramconfig', ) )
def Plugin( entMan ):
   DefaultConfigPlugin.Acl.registerService( entMan, 'dhcpRelay' )
   # Register flash:/persist/DhcpPdRoutes.db as a file to be replicated
   # to the standby supervisor.
   config = entMan.root()[ 'redundancy' ][ 'fileReplication' ][ 'config' ]
   rc = config.newRequester( "DhcpRelay", "inotify" )
   rc.enabled = True
   pdRoutesDbFile = "flash:/persist/DhcpPdRoutes.db"
   rc.newFile( pdRoutesDbFile, pdRoutesDbFile )
