# Copyright (c) 2010, 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Plugins

@Plugins.plugin()
def Plugin( entMan ):

   import SnmpNotificationRegistrar # pylint: disable=import-outside-toplevel

   subs = None

   intfDesc = 'Enable entStateOperEnabled/Disabled traps for interfaces'
   entStateOper = { 'name': 'ent-state-oper',
                    'parentPath': [ 'entity' ],
                    'notifications': [ ( 'interfaces', intfDesc ) ],
                    'description': 'certain entStateOper' }
   subs = [ entStateOper ]

   SnmpNotificationRegistrar.registerNotificationType( entMan, 'entity',
      notifications=(
         'entConfigChange',
         'entStateOperEnabled',
         'entStateOperDisabled', 
         'aristaEntSensorAlarm', ),
      subtypes=subs ) 
