# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import SysdbUtil
import Plugins
import DefaultConfigPlugin.Acl
from HttpServiceConstants import ServerConstants

def registerHttpServiceConfig( entityManager, name, 
                               defaultEnabled=False, serviceName=None ):
   config = entityManager.lookup( "mgmt/capi/config" )
   if name not in config.service:
      config.newService( name )
      config.service[ name ].enabled = defaultEnabled
      if serviceName:
         config.service[ name ].serviceName = serviceName
   return config.service[ name ]

@Plugins.plugin( provides=( 'mgmt/capi/config', ),
                 requires=( 'acl/paramconfig', ) )
def Plugin( entityManager ):
   SysdbUtil.addLogFacility( entityManager, "HTTPSERVICE" )
   config = entityManager.lookup( "mgmt/capi/config" )
   config.httpConfig = ( "HttpServer", )
   config.httpsConfig = ( "HttpsServer", )
   config.localHttpConfig = ( "HttpLocalConfig", )
   config.unixConfig = ( "UnixConfig", )

   DefaultConfigPlugin.Acl.registerService( entityManager, 
                                            ServerConstants.serviceName ) 
