# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Plugins
from ServicePluginContext import addServiceInfo

@Plugins.plugin( requires=( 'mgmt/controller/service/config', ) )
def Plugin( entMan ):
   mssclientVersions = ( ( 1, "First version of Macro Segmentation Service" ), )
   # Create config state for Mss service
   addServiceInfo( entMan.serviceClientCtx_, "Mss", mssclientVersions,
                   enabled=True )

   mssclientL3Versions = (
                        ( 1, "First version of Macro Segmentation L3 Service" ),
                        ( 2, "Second version of Macro Segmentation L3 Service" ) )
   # Create config state for Mss L3 service
   addServiceInfo( entMan.serviceClientCtx_, "MssL3", mssclientL3Versions,
                   enabled=True )
