# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import SysdbUtil
import Plugins
from Debug import newDebugMessage
import os
import OspfConsts
import DefaultConfigPlugin.Acl

@Plugins.plugin( provides=( 'debug/config/ip/ospf', ),
                 requires=( 'debug/config/ip', 'acl/paramconfig' ) )
def Plugin( entMan ):
   SysdbUtil.addLogFacility( entMan, 'OSPF' )

   debugConfig = entMan.lookup( 'debug/config' )

   ospfDebugMessages = [
      newDebugMessage( "adj", "Adjacent device state" ),
      newDebugMessage( "config", "Configuration changes and errors" ),
      newDebugMessage( "database-detail", "OSPF database change detail" ),
      newDebugMessage( "events", "OSPF events" ),
      newDebugMessage( "packet", "Packet information" ),
      newDebugMessage( "routing", "Routing database updates" ),
      newDebugMessage( "spf-detail", "SPF calculation details" ),
      newDebugMessage( "spf-statistics", "SPF calculation statistics" )
      ]

   if os.environ.get( 'OSPF_UNUSED_DEBUG_MESSAGES' ):
      ospfDebugMessages.extend( [
            newDebugMessage( "restart", "Messages related to graceful restarts" ),
            newDebugMessage( "traffic-eng", "Traffic engineering messages" )
            ] )

   ipConfig = debugConfig.subcategory[ 'ip' ]
   ospfProtocol = ipConfig.subcategory.newMember( 'ospf', 'Ospf protocol' )
   ospfProtocol.hiddenCategory = True

   for message in ospfDebugMessages:
      ospfProtocol.messageType.addMember( message )

   DefaultConfigPlugin.Acl.registerService( entMan, OspfConsts.serviceName )

