#!/usr/bin/env python3
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import SysdbUtil
import Tracing
import Tac

t0 = Tracing.trace0
tacSampleRate = Tac.Type( 'PostcardTelemetry::SampleRate' )
UniqueId = Tac.Type( "Ark::UniqueId" )

def Plugin( entMan ):
   SysdbUtil.addLogFacility( entMan, "POSTCARDTELEMETRY" )
   policyCfg = entMan.lookup( "postcardtelemetry/policyconfig" )
   samplePolicyCfg = entMan.lookup( 'postcardtelemetry/samplePolicies/input/cli' )

   policyCfg.sampleRate = tacSampleRate.sampleRateInvalid

   # Adding default profile
   policyCfg.portProfile.newMember( 'default' )
   policyCfg.portProfile[ 'default' ].samplePolicy = 'default'

   # Adding default sample policy
   tacMatchOption = Tac.Type( 'PolicyMap::ClassMapMatchOption' )
   ClassPriorityConstant = Tac.Type( 'TrafficPolicy::ClassPriorityConstant' )

   pmapInput = samplePolicyCfg.pmapType.pmapInput.newMember(
      'default', samplePolicyCfg.pmapType.type )
   subCfg = pmapInput.subconfig.newMember( 'default', UniqueId() )
   pmapInput.currCfg = subCfg

   # Adding default ipv4 match
   pmapInput.currCfg.classAction.newMember( 'ipv4-all-default' )
   cmap = pmapInput.currCfg.rawClassMap.newMember( 'ipv4-all-default', UniqueId() )
   matchOption = tacMatchOption.matchIpAccessGroup
   cmapMatch = cmap.match.newMember( matchOption )
   cmapMatch.structuredFilter = ( "", )
   classPriority = ClassPriorityConstant.classV4DefaultPriority
   pmapInput.currCfg.classPrio[ classPriority ] = 'ipv4-all-default'

   # Adding sample action to default ipv4 match
   sampleAction = samplePolicyCfg.actions.sampleAction.newMember( 'ipv4-all-default',
                                                                  UniqueId() )
   pmapInput.currCfg.classAction[ 'ipv4-all-default' ].policyAction.addMember(
      sampleAction )

   # Adding default ipv6 match
   pmapInput.currCfg.classAction.newMember( 'ipv6-all-default' )
   cmap = pmapInput.currCfg.rawClassMap.newMember(
      'ipv6-all-default', UniqueId() )
   matchOption = tacMatchOption.matchIpv6AccessGroup
   cmapMatch = cmap.match.newMember( matchOption )
   cmapMatch.structuredFilter = ( "", )
   classPriority = ClassPriorityConstant.classV6DefaultPriority
   pmapInput.currCfg.classPrio[ classPriority ] = 'ipv6-all-default'

   # Adding sample action to default ipv6 match
   sampleAction = samplePolicyCfg.actions.sampleAction.newMember(
      'ipv6-all-default', UniqueId() )
   pmapInput.currCfg.classAction[ 'ipv6-all-default' ].policyAction.addMember(
      sampleAction )

   samplePolicyCfg.pmapType.pmap.addMember( pmapInput )
