#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import QosLib
from DefaultConfigPlugin import Qos
from QosTypes import tacPMapNm
import os

def runningInWorkspace():
   # Return True only if we are in a workspace and not on a switch (SWI).
   # This is verified by checking A4_CHROOT environment variable, which is only
   # and always present in a workspace, and never present on a switch.
   return 'A4_CHROOT' in os.environ

def createDefaultConfigCopp( cliCfg, aclCfg ):
   pmap = QosLib.pmapIs( aclCfg, tacPMapNm.coppName, 'mapControlPlane' )
   QosLib.createDefaultStaticClass( aclCfg, pmap )
   QosLib.coppServicePolicyIs( cliCfg, no=False )


# Setup hooks in Qos.py
# pylint: disable-msg=protected-access
# Registration of callbacks for createDefaultConfig
Qos._createDefaultConfigCallback[ QosLib.coppMapType ] = createDefaultConfigCopp
# pylint: enable-msg=protected-access

def Plugin( entMan ):
   # do nothing
   pass
