# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import SysdbUtil
import Plugins, DefaultConfigPlugin.Acl
import Tac

from SysMgrLib import updateAuthenticationMethods

AuthenMethod = Tac.Type( "Mgmt::Ssh::AuthenMethod" )

@Plugins.plugin( provides=( 'mgmt/ssh/config', ),
                 requires=( 'acl/paramconfig', ) )
def Plugin( entMan ):
   SysdbUtil.addLogFacility( entMan, "SECURITY" )

   DefaultConfigPlugin.Acl.registerService( entMan, 'ssh' )

   sshConfig = entMan.lookup( 'mgmt/ssh/config' )

   sshConfig.authenticationMethodList.clear()

   defaultAuthenticationMethods = [
      [ AuthenMethod.keyboardInteractive ],
      [ AuthenMethod.publicKey ] ]
   updateAuthenticationMethods( sshConfig, defaultAuthenticationMethods )
