# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
import Tracing
import Tac
from DefaultSslLib import writeFile, createDirs

t0 = Tracing.trace0

Constants = Tac.Type( "Mgmt::Security::Ssl::Constants" )

ARISTA_PROFILE = "ARISTA_DEFAULT_PROFILE"

ARISTA_SIGNING_CA_FILE = "ARISTA_SIGNING_CA.crt"

ARISTA_ROOT_CA_FILE = "ARISTA_ROOT_CA.crt"

ARISTA_SIGNING_CA = """-----BEGIN CERTIFICATE-----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-----END CERTIFICATE-----
"""

ARISTA_ROOT_CA = """-----BEGIN CERTIFICATE-----
MIIFqTCCA5GgAwIBAgIQf0sXyWSVALVDEks+rXyyHDANBgkqhkiG9w0BAQsFADA6
MTgwNgYDVQQDEy9BcmlzdGEgTmV0d29ya3MgSW50ZXJuYWwgSVQgUm9vdCBDZXJ0
IEF1dGhvcml0eTAeFw0xNzA1MzEyMjA1MDJaFw0zNzA1MzEyMjE0NTlaMDoxODA2
BgNVBAMTL0FyaXN0YSBOZXR3b3JrcyBJbnRlcm5hbCBJVCBSb290IENlcnQgQXV0
aG9yaXR5MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAqBy0lxZZL0Te
kCPotP3Go+H1KSyvjEgif8zQw3SlEGHX5LrMbrHLWjeWX2oaNRJSt9aLp4jzCPoE
FXAxks5lnUwTN7kDFZJbSbzkGjkPCNu+zFPpKqXJqKi2Oyn+ZZGqExfMNN9hWDcb
CYmKd/ptYhOEuOE6YQNZHbVX0FsNtZuhKhp6YrsyceyGry1rQFuwIFYTuOmtTtow
BaJpurED6+OoTYzmkYZxoggPknmmhKXy/utVMSaF0p0Cyd9YCNLKOYufkPCyWuDc
nc27M8DNmnmvIEbhVXzVRY//cFEE6cHQq2gSfB+P/kSOh+rVlXXwFYmtELKaVEVo
Kke3TP+Wrjy7yRuocXe67WP+RtMx4G5J6w5wZZnOFN4BhdjZdErbLVBpHP63wLX1
4P5jfBmT/PTmb3jS2OwBA+MmkYxMfERvz35QaIsrtiot3gIIPU01642dYbLZVhww
YE8xWMc/8qxirBSa/ARDa2NF+VQB849lgoihYvUvSFB6Ps8Nk8Cq2MrmFYyyJNJG
xIHEv4K7/W9Zs3ROWMtfjrrErao8wiz3qnI3JmzQvimvDI/B+dE0oohcHRmlpkeW
R3iUqHaPgfvIiqpgI6WU/afFeBgca6u7DCzZ0hv5bkpS/ZnLZy7mwZTRN1wP59PQ
uFSB08JU4CtpSnFugBP+3AqJbpPWSq0CAwEAAaOBqjCBpzALBgNVHQ8EBAMCAYYw
DwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQULe/a5u/PHHdRv1oCqSjNlACt4cow
EAYJKwYBBAGCNxUBBAMCAQAwVgYDVR0gBE8wTTBLBgwrBgECAREHAQQCAQMwOzA5
BggrBgEFBQcCARYtaHR0cDovL2l0LXBraS5hcmlzdGFuZXR3b3Jrcy5jb20vcGtp
L2Nwcy5odG1sMA0GCSqGSIb3DQEBCwUAA4ICAQAEX90Ccn/4YUSuh2rdCg/PsjIT
doJj0n20T4AqPpe3gbRNYDaynVmrr/EHZiPZQHQIWtw01L+61RXMnAbDULLkYI/B
mMeWyQzp4msVwvsTRFDB7b86h8rSegLPLxEWI7Zz5euPt/ENoMqVYGllatYSFVor
Zhj45Sr89wjeSxIiTkkbzsQWvzDdB+4rZ+/5sHMFr4p9SJudKEKn6UbA+HUAjL87
ghjKckL2mN0TqVKg3rXr7AQr1k0F7omaDl6nvgRhKxnTpK9MXLkPgW3tTWMu2IqV
zYZLLBqeldL1Xa8ltkTOHmxSWWItTRu7b6c22OcAkbOVbtNa+kSQeD3/VuocwV5F
juHK118TKRTZ0gRN2lBg4KHsYNJw4l7NO/HYMScIktmr787ppR/AHvyZd5W+CuF1
M/aqpE2H/6OPf0fWCykV8uEDYBQjG7hLfjncz8W8kAMgieoyq/SLblA4wIYkJQ3G
+GE0ZI4ZJhsrOGZRaBqF2AxosZL61LNP0Mgb3TQ+5x/GSL4YyQQzOTMeNaLSQkeA
4kW2iBpoXyguNISShATrm1yfz+bIINT752coRXV66LXktS6Ap9zk6Q1IsldlA6aD
A64p2RcH8aI7fFhhkgYuRWgGpW5vE/g9RRxJFWi6cShrdmL1oNcbkWDoPG/3l8OD
PBQeNj5YfzrvoC49tg==
-----END CERTIFICATE-----
"""

def createDefaultSslProfile( profileConfig ):
   signingCrtFile = Constants.certPath( ARISTA_SIGNING_CA_FILE )
   rootCrtFile = Constants.certPath( ARISTA_ROOT_CA_FILE )

   # Create SSL cert dir if it does not exist
   if createDirs():
      # Write default certs to the cert directory
      writeFile( signingCrtFile, ARISTA_SIGNING_CA )
      writeFile( rootCrtFile, ARISTA_ROOT_CA )

   # Create default SSL profile with the two trusted certificates
   defaultProfile = profileConfig.newProfileConfig( ARISTA_PROFILE )
   defaultProfile.profileType = "profileTypeSsl"
   defaultProfile.trustedCert[ ARISTA_SIGNING_CA_FILE ] = 1
   defaultProfile.trustedCert[ ARISTA_ROOT_CA_FILE ] = 1
