# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
import os
import errno
import SslCertKey
import Tracing
import Tac
from DefaultSslLib import writeFile, createDirs

t0 = Tracing.trace0

Constants = Tac.Type( "Mgmt::Security::Ssl::Constants" )
CertKeyPair = Tac.Type( "Mgmt::Security::Ssl::CertKeyPair" )

SELFSIGNED_PROFILE = "DEFAULT_SELF_SIGNED"
SELFSIGNED_CERT_FILE = "SELFSIGNED.crt"
SELFSIGNED_KEY_FILE = "SELFSIGNED.key"

def doCreateDefaultSslSelfSignedProfile( certFile, keyFile ):
   try:
      cert, key = SslCertKey.generateCertificate( commonName=SELFSIGNED_PROFILE )
   except ( OSError, SslCertKey.SslCertKeyError ) as e:
      # pylint: disable-next=no-member
      if isinstance( e, OSError ) and e.errno == errno.EACCES:
         t0( "Permission denied while generating self-signed"
               " SSL cert and key" )
      else:
         t0( "Unknown error while generating self-signed SSL cert and key:",
            str( e ) )
      return
   if createDirs():
      # Write self-signed cert and key to the cert directory
      writeFile( certFile, cert )
      writeFile( keyFile, key )

def createDefaultSslSelfSignedProfile( profileConfig ):
   certFile = Constants.certPath( SELFSIGNED_CERT_FILE )
   keyFile = Constants.keyPath( SELFSIGNED_KEY_FILE )
   if not os.path.exists( certFile ) or not os.path.exists( keyFile ):
      doCreateDefaultSslSelfSignedProfile( certFile, keyFile )
   # Create SSL self-signed profile
   defaultProfile = profileConfig.newProfileConfig( SELFSIGNED_PROFILE )
   defaultProfile.profileType = "profileTypeSsl"
   defaultProfile.certKeyPair = CertKeyPair( SELFSIGNED_CERT_FILE,
                                             SELFSIGNED_KEY_FILE )
