#!/usr/bin/env arista-python
# Copyright (c) 2008, 2009, 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import _DesCrypt, base64
 
def encrypt( key, data, base64Encode=True ):
   """This function performs DES encryption on the data using the key, and
   return the encrypted data in base64 format. The size of the data should
   be less than 508 bytes"""

   # pylint: disable-next=c-extension-no-member
   encryptedData = _DesCrypt.cbcEncrypt( key, data )
   if base64Encode:
      return base64.b64encode( encryptedData )
   else:
      return encryptedData

def decrypt( key, data, base64Decode=True ):
   """This function performs DES decryption on the data using the key.
   When base64Decode is True, it decode the encrypted data before decrypting."""

   if base64Decode:
      data = base64.b64decode( data )
   return _DesCrypt.cbcDecrypt( key, data ) # pylint: disable=c-extension-no-member

