# Copyright (c) 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Logging

DHCP_ADDRESS_ASSIGNMENT_SUCCESS = Logging.LogHandle(
   "DHCP_ADDRESS_ASSIGNMENT_SUCCESS",
   severity=Logging.logInfo,
   fmt="Interface %s assigned IP address %s/%s for %s seconds",
   explanation="A DHCP server responded with the IP address for "
               "the named interface. After the allotted time, "
               "this IP address will expire.",
   recommendedAction=Logging.NO_ACTION_REQUIRED )

DHCP_ADDRESS_ASSIGNMENT_FAIL = Logging.LogHandle(
   "DHCP_ADDRESS_ASSIGNMENT_FAIL",
   severity=Logging.logWarning,
   fmt="Interface %s failed to acquire an IP address",
   explanation="The DHCP client for the named interface is unable to "
               "acquire an IP address. This could be because the DHCP "
               "server is unreachable or the server is unable to provide "
               "an address at this time.",
   recommendedAction="Check that there is a DHCP server in the network that is "
                     "reachable from the named interface( directly or via a "
                     "DHCP relay), and that the DHCP server is configured to "
                     "provide an address for the named interface on the switch." )

DHCP_ADDRESS_RELEASE = Logging.LogHandle(
   "DHCP_ADDRESS_RELEASE",
   severity=Logging.logInfo,
   fmt="Releasing IP address %s/%s on interface %s",
   explanation="Removing the DHCP client configuration from the named interface "
               "causes the system to release the address currently assigned to "
               "the interface.",
   recommendedAction=Logging.NO_ACTION_REQUIRED )

DHCP_ADDRESS_EXPIRE = Logging.LogHandle(
   "DHCP_ADDRESS_EXPIRE",
   severity=Logging.logWarning,
   fmt="Lease for IP address %s/%s on interface %s expired",
   explanation="The IP address lease for the named interface "
               "has expired. The DHCP client for the interface "
               "is unable to acquire an IP address. This could be "
               "because the DHCP server is unreachable or the server "
               "is unable to provide an address at this time.",
   recommendedAction="Check that there is a DHCP server in the network that is "
                     "reachable from the named interface( directly or via a "
                     "DHCP relay), and that the DHCP server is configured to "
                     "provide an address for the named interface on the switch." )
