#!/usr/bin/env python3
# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from IpLibConsts import DEFAULT_VRF
from IpUtils import IpAddress
import socket

def keyVrf( vrf ):
   if vrf == DEFAULT_VRF:
      return ''
   return vrf

def keyIpAddrVrf( x ):
   if isinstance( x, dict ):
      return ( keyVrf( x[ 'vrf' ] ), IpAddress( x[ 'serverAddr' ] ) )
   else:
      return ( keyVrf( x.vrfName ), IpAddress( x.ip.v4Addr ) )

def keyIpv6AddrVrf( x ):
   if isinstance( x, dict ):
      return ( keyVrf( x[ 'vrf' ] ), IpAddress( x[ 'serverAddr' ],
                                                addrFamily=socket.AF_INET6 ) )
   else:
      return ( keyVrf( x.vrfName ), IpAddress( x.ip.v6Addr.stringValue,
                                               addrFamily=socket.AF_INET6 ) )

def keyHostnameVrf( x ):
   if isinstance( x, dict ):
      return ( keyVrf( x[ 'vrf' ] ), x[ 'serverHostname' ] )
   else:
      return ( keyVrf( x.vrfName ), x.hostname )

def formatClearDhcpRelayV6RoutesCmd( vrf=None, intf=None, prefix=None ):
   command = 'clear ipv6 dhcp relay routes'
   if vrf:
      command += f' vrf {vrf}'
   if intf:
      command += f' {intf}'
   if prefix:
      command += f' {prefix}'
   return command
