# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Ark
from TableOutput import createTable, Format

def createDhcpSnoopingCountersTable( outputHeader, counterModel ):
   output = []
   for vlan in sorted( counterModel.vlanCounters.keys() ):
      vlanCounters = counterModel.vlanCounters[ vlan ]
      output.append( [ vlanCounters.vlan, vlanCounters.requestsReceived,
                       vlanCounters.requestsForwarded,
                       vlanCounters.requestsDropped,
                       vlanCounters.repliesReceived, 
                       vlanCounters.repliesForwarded,
                       vlanCounters.repliesDropped,
                       Ark.utcTimeRelativeToNowStr( vlanCounters.resetTime ) ] )
   outputTable = createTable( outputHeader )
   for row in output:
      outputTable.newRow( *row )
   f1 = Format( justify='right', border=True )
   f2 = Format( justify='right' )
   f1.padLimitIs( True )
   f2.padLimitIs( True )
   outputTable.formatColumns( f1, f2, f2, f1, f2, f2, f1, f2 )
   return outputTable

# Sample output table of createDhcpSnoopingCountersTableDetail
#              | Dhcp Request Pkts | Dhcp Reply Pkts |
#   Interface |  Rcvd  Fwdd  Drop | Rcvd Fwdd  Drop | Last Cleared
#-------------|------ ----- ------|----- ---- ------|-------------
#Ethernet27/5 |     2     0     0 |    0    2     0 |  0:33:22 ago
#    Vlan1519 |     0     2     0 |    2    0     0 |  0:33:22 ago
#
def createDhcpSnoopingCountersTableDetail( outputHeader, vlanCounter ):
   output = []
   for intf in sorted( vlanCounter.interfaces ):
      intfCounter = vlanCounter.interfaces[ intf ]
      output.append( [ intf,
                       intfCounter.requestsReceived,
                       intfCounter.requestsForwarded,
                       intfCounter.requestsDropped,
                       intfCounter.repliesReceived,
                       intfCounter.repliesForwarded,
                       intfCounter.repliesDropped,
                       Ark.utcTimeRelativeToNowStr( vlanCounter.resetTime ) ] )
   outputTable = createTable( outputHeader )
   for row in output:
      outputTable.newRow( *row )
   f1 = Format( justify='right', border=True )
   f2 = Format( justify='right' )
   f1.padLimitIs( True )
   f2.padLimitIs( True )
   outputTable.formatColumns( f1, f2, f2, f1, f2, f2, f1, f2 )
   return outputTable

def dhcpSnoopingHwStatusReady( sliceInfo, hwStatus ):
   if sliceInfo and ( sliceInfo.generationId == hwStatus.genId ) and \
      hwStatus.dhcpSnoopingSupported:
      return True
   elif not sliceInfo and hwStatus.dhcpSnoopingSupported and \
           ( hwStatus.genId == 0xffffffff ):
      # For a system that creates only one instance of HwStatus, the
      # genId should be set to the max value.
      return True
   else:
      return False
