# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
# pylint: disable-msg=E0401   # ignore import errors
from EDTAccess import EDTCmd, DutAccessorBase

class DutInfoPlugin( DutAccessorBase ):
   def __init__( self, useCli=True ):
      super().__init__()

   def systemVersionInfo( self ):
      return self.dutCli.privCmd( "show version", jsonOutput=True ) or {}

   def systemVersion( self ):
      return self.systemVersionInfo().get( "version" )

   def systemMacAddr( self ):
      return self.systemVersionInfo().get( "systemMacAddress" )

   def dutProperties( self ):
      if not self.dutInfo:
         # pylint: disable=no-member
         self.getArtInfo()
      return self.dutInfo.dutProperties if self.dutInfo else {}

   @EDTCmd
   def showDutName( self ):
      '''Show DUT name'''
      print( self.dutName )

   @EDTCmd
   def showDutProperties( self ):
      '''Show DUT properties'''
      for propName, propVal in sorted( self.dutProperties().items() ):
         print( f"{propName}: {propVal}" )

   @EDTCmd
   def showSystemMacAddr( self ):
      '''Show system MAC address'''
      print( self.systemMacAddr() )

   @EDTCmd
   def showVersion( self ):
      '''Show system version'''
      print( self.systemVersion() )

   @EDTCmd
   def showModel( self ):
      '''Show device model'''
      print( self.systemVersionInfo().get( "modelName" ) )
