#!/usr/bin/env python3
# Copyright (c) 2008, 2009, 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tracing
from EbraTestBridgePythonImpl import getPythonIntoCppShimContext
from EbraTestBridgePythonImpl import ArfaShimDestLookupHandlers
from EbraTestBridgePythonImpl import ArfaShimTrapLookupHandler

handle = Tracing.Handle( 'EbraTestBridge' )
t2 = handle.trace2

etbaCtx = None

def bridgeInit( bridge ):
   t2( 'IgmpSnooping bridgeInit' )

   shim = getPythonIntoCppShimContext()
   assert shim

   plugin = shim.plugin( "IgmpSnooping" )
   assert plugin

   etbaCtx.registerDestLookupHandler(
      ArfaShimDestLookupHandlers( plugin.destLookupStep ) )
   etbaCtx.registerTrapLookupHandler(
      ArfaShimTrapLookupHandler( plugin.trapStep, True ) )

def Plugin( ctx ):
   global etbaCtx
   etbaCtx = ctx
   ctx.registerBridgeInitHandler( bridgeInit )
