#!/usr/bin/env python3
# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from EbraTestBridgePythonImpl import (
      ArfaShimFloodsetIncludesCpuHandler,
      getPythonIntoCppShimContext,
)

def floodsetIncludesCpu( bridge, vlanId, dstMacAddr, data ):
   # Call into the C++ Isis plugin
   shim = getPythonIntoCppShimContext()
   assert shim

   plugin = shim.plugin( "Isis" )
   assert plugin

   shimClass = ArfaShimFloodsetIncludesCpuHandler( plugin.decisionStep )
   return shimClass( bridge, vlanId, dstMacAddr, data )

def Plugin( ctx ):
   ctx.registerFloodsetIncludesCpuHandler( floodsetIncludesCpu )
