#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import Tracing
from EbraTestBridgePythonImpl import getPythonIntoCppShimContext

handle = Tracing.Handle( 'SftEtbaPlugin' )
t0 = handle.trace0

def performSampling( bridge, data, srcPort, finalIntfs ):
   # Call into the C++ SFT plugin
   shim = getPythonIntoCppShimContext()
   assert shim

   pktCtx = shim.pktCtx( data, srcPort.name() )

   sftPlugin = shim.plugin( "SampledFlowTracker" )
   assert sftPlugin
   sampler = sftPlugin.sftSamplerHelper
   # slow Etba handling of ingress/egress sampling based on configuration
   if sampler.ingressEnabled( srcPort.name() ):
      sftPlugin.inputSampler.process( pktCtx )
   else:
      for intf in finalIntfs:
         cDstPort = shim.getPort( intf )
         oCtx = Tac.newInstance( "Arfa::OutputPipelineContext", pktCtx,
                                 cDstPort, None )
         sftPlugin.outputSampler.process( oCtx )

def Plugin( ctx ):
   if ctx.inArfaMode():
      # C++ plugin handles this
      return
   t0( 'Entering Plugin( ctx ) in EbraTestBridgePlugin/Sft.py' )
   ctx.registerSflowHandler( performSampling )
