#!/usr/bin/env python3
# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

LIFETIMEA = "Lifetime A"
LIFETIMEB = "Lifetime B"
RESERVES = "Reserves"

def emmcHealthStatus( status ):
   """Returns a dict of dicts like so:
   {
      "drive": {
                  "Lifetime A": 0.8,
                  "Lifetime B": 0.5,
                  "Reserves": 1.0,
               },
      ...
   }
   """

   # NOTE: Here, we assume that lifetimeA will always
   #       correspond to SLC health and that lifetimeB
   #       will always correspond to MLC health. This
   #       is not true for all eMMCs.
   #       See BUG546584.

   healths = {}

   deviceData = status.emmcData.deviceData
   connectedDisks = status.connectedDevices.disk

   for serial, device in deviceData.items():
      results = {}

      lifetimeTypA = device.lifetimeEstTypA
      if lifetimeTypA.present():
         results[ LIFETIMEA ] = lifetimeTypA.percentValue() / 100

      lifetimeTypB = device.lifetimeEstTypB
      if lifetimeTypB.present():
         results[ LIFETIMEB ] = lifetimeTypB.percentValue() / 100

      reserves = device.preEolInfo
      if reserves.present():
         results[ RESERVES ] = reserves.percentValue() / 100

      mount = connectedDisks[ serial ].fsName()
      healths[ mount ] = results

   return healths
