# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac

def _getType( namespace, name=None ):
   if name:
      return Tac.Type( namespace + "::" + name )
   else:
      return Tac.Type( namespace )

class PoePortStatusTacTypes:
   namespace = "Environment::Power::PoePortStatus"

   @staticmethod
   def _getType( name=None ):
      return _getType( PoePortStatusTacTypes.namespace, name )

   @staticmethod
   def PoweredDeviceClass():
      return PoePortStatusTacTypes._getType( "PoweredDeviceClass" )

   @staticmethod
   def PoePortState():
      return PoePortStatusTacTypes._getType( "PoePortState" )

class PortStatusTacTypes:
   namespace = "Environment::Power::PoePortStatus::PortStatus"

   @staticmethod
   def _getType( name=None ):
      return _getType( PortStatusTacTypes.namespace, name )

   @staticmethod
   def PortStatus():
      return PortStatusTacTypes._getType()

   @staticmethod
   def createPortStatus( *args, **kwargs ):
      return PortStatusTacTypes.PortStatus()( *args, **kwargs )

   @staticmethod
   def PowerType():
      return PortStatusTacTypes._getType( "PowerType" )

   @staticmethod
   def PowerSource():
      return PortStatusTacTypes._getType( "PowerSource" )

   @staticmethod
   def PowerPriority():
      return PortStatusTacTypes._getType( "PowerPriority" )

   @staticmethod
   def PsePoweringStatus():
      return PortStatusTacTypes._getType( "PsePoweringStatus" )

   @staticmethod
   def PsePowerPairsExt():
      return PortStatusTacTypes._getType( "PsePowerPairsExt" )

   @staticmethod
   def DualSignaturePowerClassExtMode():
      return PortStatusTacTypes._getType( "DualSignaturePowerClassExtMode" )

   @staticmethod
   def PowerClassExt():
      return PortStatusTacTypes._getType( "PowerClassExt" )

   @staticmethod
   def PowerTypeExt():
      return PortStatusTacTypes._getType( "PowerTypeExt" )

