# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import Tracing
from TypeFuture import TacLazyType

t0 = Tracing.trace0

tempSensorHwStatusStringMap = { 'unknownHwStatus' : 'Unknown',
                                'ok' : 'Ok',
                                'invalidReading' : 'Invalid',
                                'failed' : 'Failed',
                                'disabled' : 'Disabled' }

tempAlarmLevelStringMap = { 'unknownTemperatureAlarmLevel' : 'Unknown',
                            'temperatureOk' : 'Ok',
                            'temperatureOverheating' : 'Overheating',
                            'temperatureSensorFailure' : 'Sensor Failed',
                            'temperatureCritical' : 'Critical' }


coolingAlarmLevelStringMap = { 'unknownCoolingAlarmLevel' : 'Unknown',
                            'coolingOk' : 'Ok',
                            'fanTrayFailedOrMissing' : 'Failed or missing fan',
                            'insufficientFans' : 'Insufficient fans',
                            'insufficientFabricCards' : 'Insufficient fabric cards',
                            'incompatibleFans' : 'Incompatible fans' }

fanAlarmLevelStringMap = { 'unknownFanAlarmLevel' : 'Unknown',
                           'fanAlarmOk' : 'OK',
                           'fanAlarmDebugMode' : 'Debug fan control mode',
                           'fanAlarmTempCritical' : 'System temperature is critical',
                           'fanAlarmManualMode' : 'Manual fan control mode',
                           'fanAlarmForcedSpeed' : 'Forced speed mode',
                           'fanAlarmTempOverheating' : 'System is overheating',
                           'fanAlarmCoolingNotOk' : 'Cooling status is not OK',
                           'fanAlarmTempSensorFailure' :
                              'Temperature sensors failure',
                           'fanAlarmUnknownAirflow' :
                              'Fans air flow is undefined',
                           'fanAlarmIncorrectConfig' :
                              'Missing fan configuration' }

airflowDirectionStringMap = { 'unknownAirflowDirection' : 'unknown',
                     'frontToBackAirflow' : 'port-side intake',
                     'backToFrontAirflow' : 'port-side exhaust',
                     'mismatchedAirflow' : 'incompatible fans inserted!' }

fanStatusStringMap = { 'unknownHwStatus' : 'Unknown',
                       'unsupported' : 'Not Supported',
                       'failed' : 'Failed',
                       'powerLoss' : 'Power Loss',
                       'ok' : 'Ok' }

fanTrayStatusStringMap = { 'notInserted' : 'Not Inserted' }
fanTrayStatusStringMap.update( fanStatusStringMap )

ActionOnOverheat = TacLazyType( "Environment::Thermostat::ActionOnOverheat" )
actionOnOverheatStringMap = {
      'actionUnknown' : 'unknown',
      'actionIgnore' : 'ignore',
      'actionShutdown' : 'shutdown',
      'actionPowercycle' : 'power-cycle', }
actionOnOverheatEnumMap = {
      'ignore' : ActionOnOverheat.actionIgnore,
      'shutdown' : ActionOnOverheat.actionShutdown,
      'power-cycle' : ActionOnOverheat.actionPowercycle, }

recoveryModeEnum = Tac.Type( "Environment::Thermostat::RecoveryModeOnOverheat" )
recoveryModeOnOverheatStringMap = {
      'recoveryModeNA': 'not applicable',
      'recoveryModeNormal': 'normal',
      'recoveryModeRestricted': 'restricted',
      }

MAX_NUM_OF_COOLING_ZONES = 64

def numZonesToProfileName( num, supportedProfile ):
   if num == 0:
      return ""

   for name, n in supportedProfile.items():
      if n == num:
         return name

   t0( "Can't find profile with", num, "domains in it" )
   return None

def getActionOnOverheatStrings():
   return list( actionOnOverheatStringMap )

def getActionOnOverheatDisplayString( action ):
   assert action in actionOnOverheatStringMap
   return actionOnOverheatStringMap[ action ]

def getRecoveryModeOnOverheatStrings():
   return list( recoveryModeOnOverheatStringMap )

def getRecoveryModeOnOverheatDisplayString( status ):
   assert status in recoveryModeOnOverheatStringMap
   return recoveryModeOnOverheatStringMap[ status ]

def getSensorHwStatusStrings():
   return list( tempSensorHwStatusStringMap )

def getSensorHwStatusDisplayString( status ):
   assert status in tempSensorHwStatusStringMap
   return tempSensorHwStatusStringMap[ status ]

def getCoolingAlarmLevelStrings():
   return list( coolingAlarmLevelStringMap )

def getFanAlarmLevelStrings():
   return list( fanAlarmLevelStringMap )

def getCoolingAlarmLevelDisplayString( level ):
   assert level in coolingAlarmLevelStringMap
   return coolingAlarmLevelStringMap[ level ]

def getAirflowDirectionStrings():
   return list( airflowDirectionStringMap )

def getAirflowDirectionDisplayString( direction ):
   assert direction in airflowDirectionStringMap
   return airflowDirectionStringMap[ direction ]

def getTempAlarmLevelStrings():
   return list( tempAlarmLevelStringMap )

def getTempAlarmLevelDisplayString( level ):
   assert level in tempAlarmLevelStringMap
   return tempAlarmLevelStringMap[ level ]

def getFanStatusStrings():
   return list( fanStatusStringMap )

def getFanStatusDisplayString( status ):
   assert status in fanStatusStringMap
   return fanStatusStringMap[ status ]

def getFanTrayStatusStrings():
   return list( fanTrayStatusStringMap )

def getFanTrayStatusDisplayString( status ):
   assert status in fanTrayStatusStringMap
   return fanTrayStatusStringMap[ status ]
