#!/usr/bin/env python3
# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from TypeFuture import TacLazyType
import Tac

tacErrorType = Tac.Type( "Eoam::ErrorType" )
tacEoamAction = Tac.Type( "Eoam::Action" )
tacEoamInterval = Tac.newInstance( "Eoam::Interval" )
tacIntervalUnit = Tac.Type( "Eoam::IntervalUnit" )
tacRateUnit = Tac.Type( 'FlowGenerator::FlowRateUnit' )
tacPacketRateAndUnit = Tac.Type( 'FlowGenerator::PacketRateAndUnit' )

errorTypeToEnumMap = { 'fcs':tacErrorType.errorFcs,
                       'symbol':tacErrorType.errorSymbol }

actionToEnumMap = { 'log' : tacEoamAction.actionLog,
                    'errdisable' : tacEoamAction.actionErrdisable,
                    'linkfault' : tacEoamAction.actionLinkfault }

enumToActionMap = { tacEoamAction.actionLog : 'log',
                    tacEoamAction.actionErrdisable : 'errdisable',
                    tacEoamAction.actionLinkfault : 'linkfault' }

intervalUnitToEnumMap = { 'secs' : tacIntervalUnit.intervalSecs,
                          'frames' : tacIntervalUnit.intervalFrames }

enumToIntervalMap = { tacIntervalUnit.intervalSecs : 'secs',
                      tacIntervalUnit.intervalFrames : 'frames' }

enumToRateUnitMap = { tacRateUnit.rateUnitKbps : 'kbps',
                      tacRateUnit.rateUnitMbps : 'mbps',
                      tacRateUnit.rateUnitGbps : 'gbps' }

rateUnitToEnumMap = { 'kbps' : tacRateUnit.rateUnitKbps,
                      'mbps' : tacRateUnit.rateUnitMbps,
                      'gbps' : tacRateUnit.rateUnitGbps }

enumRateUnitToValueMap = \
                   { tacRateUnit.rateUnitKbps : tacPacketRateAndUnit.oneKbpsInBps,
                     tacRateUnit.rateUnitMbps : tacPacketRateAndUnit.oneMbpsInBps,
                     tacRateUnit.rateUnitGbps : tacPacketRateAndUnit.oneGbpsInBps }

FeatureEnabledEnum = TacLazyType( "FlowGenerator::FeatureEnabled" )
