# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

'''This module defines useful python wrappers around the creation of EthIntfModes.'''

from functools import partial

from EthIntfLib.Types import (
   AutonegMode,
   EthDuplex,
   EthFecEncoding,
   EthIntfMode,
   EthLaneCount,
   EthSpeed,
)

def ethIntfModeFactory( intfId, speed=None, lanes=None,
                        duplex=None, fec=None, anegMode='anegModeUnknown' ):
   ethIntfMode = EthIntfMode( intfId )
   ethIntfMode.speed = speed
   ethIntfMode.laneCount = lanes
   ethIntfMode.duplex = duplex
   ethIntfMode.fec = fec
   ethIntfMode.anegMode = anegMode

   return ethIntfMode

# Ready made templates for your convenience.

# IEEE/Consortium modes
G800_8_FULL_RS544 = partial( ethIntfModeFactory,
                             speed=EthSpeed.speed800Gbps,
                             lanes=EthLaneCount.laneCount8,
                             duplex=EthDuplex.duplexFull,
                             fec=EthFecEncoding.fecEncodingReedSolomon544 )
G400_8_FULL_RS544 = partial( ethIntfModeFactory,
                             speed=EthSpeed.speed400Gbps,
                             lanes=EthLaneCount.laneCount8,
                             duplex=EthDuplex.duplexFull,
                             fec=EthFecEncoding.fecEncodingReedSolomon544 )
G200_4_FULL_RS544 = partial( ethIntfModeFactory,
                             speed=EthSpeed.speed200Gbps,
                             lanes=EthLaneCount.laneCount4,
                             duplex=EthDuplex.duplexFull,
                             fec=EthFecEncoding.fecEncodingReedSolomon544 )
G100_4_FULL_NOFEC = partial( ethIntfModeFactory,
                             speed=EthSpeed.speed100Gbps,
                             lanes=EthLaneCount.laneCount4,
                             duplex=EthDuplex.duplexFull,
                             fec=EthFecEncoding.fecEncodingDisabled )
G100_4_FULL_RS528 = partial( ethIntfModeFactory,
                             speed=EthSpeed.speed100Gbps,
                             lanes=EthLaneCount.laneCount4,
                             duplex=EthDuplex.duplexFull,
                             fec=EthFecEncoding.fecEncodingReedSolomon )
G100_2_FULL_RS544 = partial( ethIntfModeFactory,
                             speed=EthSpeed.speed100Gbps,
                             lanes=EthLaneCount.laneCount2,
                             duplex=EthDuplex.duplexFull,
                             fec=EthFecEncoding.fecEncodingReedSolomon544 )
G50_2_FULL_NOFEC = partial( ethIntfModeFactory,
                            speed=EthSpeed.speed50Gbps,
                            lanes=EthLaneCount.laneCount2,
                            duplex=EthDuplex.duplexFull,
                            fec=EthFecEncoding.fecEncodingDisabled )
G50_2_FULL_NOFEC_CL73 = partial( ethIntfModeFactory,
                                 speed=EthSpeed.speed50Gbps,
                                 lanes=EthLaneCount.laneCount2,
                                 duplex=EthDuplex.duplexFull,
                                 fec=EthFecEncoding.fecEncodingDisabled,
                                 anegMode=AutonegMode.anegModeClause73 )
G50_2_FULL_FC = partial( ethIntfModeFactory,
                         speed=EthSpeed.speed50Gbps,
                         lanes=EthLaneCount.laneCount2,
                         duplex=EthDuplex.duplexFull,
                         fec=EthFecEncoding.fecEncodingFireCode )
G50_2_FULL_RS528 = partial( ethIntfModeFactory,
                            speed=EthSpeed.speed50Gbps,
                            lanes=EthLaneCount.laneCount2,
                            duplex=EthDuplex.duplexFull,
                            fec=EthFecEncoding.fecEncodingReedSolomon )
G50_2_FULL_RS528_CL73 = partial( ethIntfModeFactory,
                                 speed=EthSpeed.speed50Gbps,
                                 lanes=EthLaneCount.laneCount2,
                                 duplex=EthDuplex.duplexFull,
                                 fec=EthFecEncoding.fecEncodingReedSolomon,
                                 anegMode=AutonegMode.anegModeClause73 )
G50_1_FULL_RS544 = partial( ethIntfModeFactory,
                            speed=EthSpeed.speed50Gbps,
                            lanes=EthLaneCount.laneCount1,
                            duplex=EthDuplex.duplexFull,
                            fec=EthFecEncoding.fecEncodingReedSolomon544 )
G40_4_FULL_NOFEC = partial( ethIntfModeFactory,
                            speed=EthSpeed.speed40Gbps,
                            lanes=EthLaneCount.laneCount4,
                            duplex=EthDuplex.duplexFull,
                            fec=EthFecEncoding.fecEncodingDisabled )
G40_2_FULL_RS528 = partial( ethIntfModeFactory,
                            speed=EthSpeed.speed40Gbps,
                            lanes=EthLaneCount.laneCount4,
                            duplex=EthDuplex.duplexFull,
                            fec=EthFecEncoding.fecEncodingReedSolomon )
G25_1_FULL_NOFEC = partial( ethIntfModeFactory,
                            speed=EthSpeed.speed25Gbps,
                            lanes=EthLaneCount.laneCount1,
                            duplex=EthDuplex.duplexFull,
                            fec=EthFecEncoding.fecEncodingDisabled )
G25_1_FULL_NOFEC_CL73 = partial( ethIntfModeFactory,
                                 speed=EthSpeed.speed25Gbps,
                                 lanes=EthLaneCount.laneCount1,
                                 duplex=EthDuplex.duplexFull,
                                 fec=EthFecEncoding.fecEncodingDisabled,
                                 anegMode=AutonegMode.anegModeClause73 )
G25_1_FULL_FC = partial( ethIntfModeFactory,
                         speed=EthSpeed.speed25Gbps,
                         lanes=EthLaneCount.laneCount1,
                         duplex=EthDuplex.duplexFull,
                         fec=EthFecEncoding.fecEncodingFireCode )
G25_1_FULL_RS528 = partial( ethIntfModeFactory,
                            speed=EthSpeed.speed25Gbps,
                            lanes=EthLaneCount.laneCount1,
                            duplex=EthDuplex.duplexFull,
                            fec=EthFecEncoding.fecEncodingReedSolomon )
G10_1_FULL_NOFEC = partial( ethIntfModeFactory,
                            speed=EthSpeed.speed10Gbps,
                            lanes=EthLaneCount.laneCount1,
                            duplex=EthDuplex.duplexFull,
                            fec=EthFecEncoding.fecEncodingDisabled )
G1_1_FULL_NOFEC = partial( ethIntfModeFactory,
                           speed=EthSpeed.speed1Gbps,
                           lanes=EthLaneCount.laneCount1,
                           duplex=EthDuplex.duplexFull,
                           fec=EthFecEncoding.fecEncodingDisabled )
G1_1_FULL_UNKNOWNFEC = partial( ethIntfModeFactory,
                                speed=EthSpeed.speed1Gbps,
                                lanes=EthLaneCount.laneCount1,
                                duplex=EthDuplex.duplexFull,
                                fec=EthFecEncoding.fecEncodingUnknown )
G1_1_FULL_NOFEC_CL28 = partial( ethIntfModeFactory,
                                speed=EthSpeed.speed1Gbps,
                                lanes=EthLaneCount.laneCount1,
                                duplex=EthDuplex.duplexFull,
                                fec=EthFecEncoding.fecEncodingDisabled,
                                anegMode=AutonegMode.anegModeClause28 )
M100_1_FULL_NOFEC = partial( ethIntfModeFactory,
                             speed=EthSpeed.speed100Mbps,
                             lanes=EthLaneCount.laneCount1,
                             duplex=EthDuplex.duplexFull,
                             fec=EthFecEncoding.fecEncodingDisabled )
UNKNOWN = partial( ethIntfModeFactory,
                   speed=EthSpeed.speedUnknown,
                   lanes=EthLaneCount.laneCountUnknown,
                   duplex=EthDuplex.duplexUnknown,
                   fec=EthFecEncoding.fecEncodingUnknown )

# Proprietary / vendor specific speeds
HG_G11_1_FULL_NOFEC = partial( ethIntfModeFactory,
                               speed=EthSpeed.speedHg11Gbps,
                               lanes=EthLaneCount.laneCount1,
                               duplex=EthDuplex.duplexFull,
                               fec=EthFecEncoding.fecEncodingDisabled )
HG_G21_2_FULL_NOFEC = partial( ethIntfModeFactory,
                               speed=EthSpeed.speedHg21Gbps,
                               lanes=EthLaneCount.laneCount2,
                               duplex=EthDuplex.duplexFull,
                               fec=EthFecEncoding.fecEncodingDisabled )
