# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

'''This module defines useful python type bindings and enum aliases for the EthIntf
package.

It should be used by tests, FRU plugins, etc... Instead of manually
declaring the TAC types / using strings as it generates automatic package
dependencies.
'''

from TypeFuture import TacLazyType

AutonegMode = TacLazyType( 'Interface::AutonegMode' )
EthDuplex = TacLazyType( 'Interface::EthDuplex' )
EthFecEncoding = TacLazyType( 'Interface::EthFecEncoding' )
EthLaneCount = TacLazyType( 'Interface::EthLaneCount' )
EthSpeed = TacLazyType( 'Interface::EthSpeed' )
EthLinkMode = TacLazyType( 'Interface::EthLinkMode' )

EthSpeedApi = TacLazyType( 'Interface::EthSpeedApi' )
EthTypesApi = TacLazyType( 'Interface::EthTypesApi' )
EthLinkModeSet = TacLazyType( 'Interface::EthLinkModeSet' )

EthIntfMode = TacLazyType( 'Interface::EthIntfMode' )

DescType = TacLazyType( 'Interface::DescType' )
EthPhyIntfDescPtrDir = TacLazyType( 'Interface::EthPhyIntfDescPtrDir' )

IntfConfigAggregatedRequests = TacLazyType(
   'Interface::IntfConfigAggregatedRequests' )

SpeedCompatSetting = TacLazyType( 'Interface::SpeedCompatSetting' )
COMPAT_UNKNOWN = SpeedCompatSetting.compatibilityUnknown
COMPAT_AUTO = SpeedCompatSetting.compatibilityAuto
COMPAT_GBPS_100 = SpeedCompatSetting.compatibility100g
COMPAT_GBPS_50 = SpeedCompatSetting.compatibility50g
COMPAT_GBPS_25 = SpeedCompatSetting.compatibility25g
COMPAT_GBPS_10 = SpeedCompatSetting.compatibility10g

EthFecEncodingConfigSet = TacLazyType( 'Interface::EthFecEncodingConfigSet' )
