# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable=consider-using-f-string

import os

import PyClient
import Tac

class EventHealthHelper:
   def __init__( self, sysname, allMetricDir=None ):
      inSimulation = "A4_CHROOT" in os.environ
      if allMetricDir:
         assert inSimulation
      self.eventHandlerName = os.environ.get( "EVENT_HANDLER_NAME" )
      self.healthMetric = os.environ.get( "EVENT_HEALTH_METRIC" )
      self.healthCategory = os.environ.get( "EVENT_HEALTH_CATEGORY" )
      self.helper = None
      if self.eventHandlerName and self.healthMetric and self.healthCategory:
         if not inSimulation:
            try:
               root = PyClient.PyClient( sysname, "EventMgr", connectTimeout=5,
                                         reconnect=False ).root()
               self.helper = \
                  root.entity[ '%s/EventMgr/EventMgr' % sysname ].eventMgr.eventSm[
                         self.eventHandlerName ].healthHelper
            except ( PyClient.RpcConnectionError, KeyError ):
               pass
         else:
            assert allMetricDir
            self.helper = Tac.newInstance( "Health::EventHelper",
                                           self.healthCategory,
                                           self.healthMetric,
                                           self.eventHandlerName,
                                           allMetricDir )

   def addViolation( self, component, timestamp, source, description,
                     severity='error' ):
      if self.helper is None:
         return

      key = Tac.Value( 'Health::EventKey', component, severity )
      bpcd = self.helper.badPolledComponentData.newMember( key, source )
      bpcd.data.newMember( timestamp, description )

   def publishEvents( self, timestamp, windowSize=0, thresholdCount=1,
                      condition="" ):
      # NOTE timestamp arg must be in seconds
      if self.helper is None:
         return

      self.helper.windowSize = windowSize
      self.helper.thresholdCount = thresholdCount
      self.helper.conditionDesc = condition
      self.helper.pollTimestamp = timestamp
