#!/usr/bin/env python3
# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tracing, Tac

t0 = Tracing.trace0
__defaultTraceHandle__ = Tracing.Handle( "EventMon" )

class ArpEventMonTableConfig:
   @staticmethod
   def name():
      return "arp"

   @staticmethod
   def schema():
      return (
         ( "time", "text", False ),
         ( "prefix", "text", True ),
         ( "intf", "text", True ),
         ( "vrf", "text", True ),
         ( "ethAddr", "text", True ),
         ( "static", "integer", False ),
         ( "delta", "text", False ),
         ( "counter", "integer UNIQUE", False ),
         )

def Plugin( ctx ):
   ctx.registerDb( ArpEventMonTableConfig() )
