# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
#!/usr/bin/env python

from Toggles.EventMonToggleLib import toggleFecBackupactivationEnabled

class FecEventMonTable():
   @staticmethod
   def name():
      return "backupactivation"

   @staticmethod
   def schema():
      return (
         ( "time", "text", False ),
         ( "counter", "integer UNIQUE", False ),
         ( "nhgName", "text", True ),
         ( "versionId", "integer", False ),
         ( "backupActivationTime", "text", True ),
         ( "programmedViaType", "text", True ),
         ( "programmedState", "text", False ),
      )


def Plugin( ctx ):
   if not toggleFecBackupactivationEnabled():
      return

   ctx.registerDb( FecEventMonTable() )
