# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
#!/usr/bin/env python

# TODO: Need to suppress loading this when the toggle is off, as various test libs
#       expect to see nhg in the command dict.
from Toggles.EventMonToggleLib import toggleNhgEventTrackingEnabled

class NhgEventMonTable():
   @staticmethod
   def name():
      return "nhg"

   # It seems users are expected to manually enter booleans on each generated line
   # here, to indicate if the sql table column should be indexed? Should we generate
   # that from a yaml tag?
   @staticmethod
   def schema():
      return (
         ( "time", "text", False ),
         ( "counter", "integer UNIQUE", False ),
         ( "nhgName", "text", True ),
         ( "eventType", "text", True ),
         ( "versionId", "integer", False ),
         ( "active", "boolean", False ),
         ( "programmedState", "text", False ),
      )


def Plugin( ctx ):
   if not toggleNhgEventTrackingEnabled():
      return

   ctx.registerDb( NhgEventMonTable() )
