#!/usr/bin/env python3
# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tracing, Tac

t0 = Tracing.trace0
__defaultTraceHandle__ = Tracing.Handle( "EventMon" )

class RouteEventMonTable:
   @staticmethod
   def name():
      return "route"

   @staticmethod
   def schema():
      return (
         ( "time", "text", False ),
         ( "prefix", "text", True ),
         ( "vrf", "text", True ),
         ( "protocol", "text", False ),
         ( "metric", "integer", False ),
         ( "preference", "integer", False ),
         ( "delta", "text", False ),
         ( "counter", "integer UNIQUE", False ),
         )

def Plugin( ctx ):
   ctx.registerDb( RouteEventMonTable() )
