# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Generator to iterate only over table configs that have a qt configuration -- we
# don't want to perform qt-specific operations for tables that use ShaqPipe.
def qtTableConfigs( cfg ):
   return ( ( name, config ) for name, config in cfg.table.items()
            if config.eventConfig.containsQt() )
