#!/usr/bin/env python3
# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

"""
THIS IS NOT A STANDALONE PSTORE PLUGIN
This handler saves the encapsulation info used to configure higher-level
protocols on fabric interfaces.
Any PD fabric users should register their own PStore plugin, using this class
as the event handler.
In the future if additional parameters need to be added to the monolithic
encapsulation info type, this plugin needs to be updated accordingly.
Adding new fields should not require a version change.

Keys:
-----

encapInfoV1: { sliceId :
                 { intfId :
                       { "encap" : string, encapsulation type
                         "linecard" : int, CES linecard
                         "numSubports" : int, CES number of subports
                         "subportNumBase" : int, CES base subport number }, }, }, }
"""

from __future__ import absolute_import, division, print_function

import AsuPStore
import Tracing

t0 = Tracing.trace0

class FabricIntfEncapInfoPStoreEventHandler( AsuPStore.PStoreEventHandler ):
   def __init__( self, encapConfigDir ):
      self.encapConfigDir_ = encapConfigDir
      super( FabricIntfEncapInfoPStoreEventHandler, self ).__init__()

   def getSupportedKeys( self ):
      return [ 'encapInfoV1' ]

   def getKeys( self ):
      return [ 'encapInfoV1' ]

   def getEncapInfo( self ):
      encapInfo = {}
      for sliceId, sliceEncapInfo in self.encapConfigDir_.items():
         encapInfo[ sliceId ] = {}
         for intfId, intfEncapInfo in sliceEncapInfo.intfEncapInfo.items():
            encapInfo[ sliceId ][ intfId ] = \
                { 'encap': intfEncapInfo.encap,
                  # BCM CES params
                  'linecard': intfEncapInfo.linecard,
                  'numSubports': intfEncapInfo.numSubports,
                  'subportNumBase': intfEncapInfo.subportNumBase, }

      return encapInfo

   def save( self, pStoreIO ):
      encapInfo = self.getEncapInfo()
      pStoreIO.set( 'encapInfoV1', encapInfo )
