# Copyright (c) 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

class FanController:
   """ A fan controller can manage fans, temperature sensors,
   and voltage sensors. """
   def __init__ ( self, name, smbusDev, fans, temps, voltages ):
      self.name_ = name              # name
      self.fans_ = fans              # Fans Controlled
      self.temps_ = [ name] + temps  # Temperature sensors
      self.dev_ = smbusDev
      # voltages are a list of [ pin, voltage, name ]
      self.voltages_ = voltages

   def fanSpeeds( self ):
      # Gives dict of fanName: [ pwm, rpms ] in 0.0 - 1.0 and rpms
      raise NotImplementedError

   def temperatures( self ):
      # Returns dict of tempName, temp
      # temperature in C starting with local, temp1, temp2, ...
      raise NotImplementedError

   def voltages( self ):
      raise NotImplementedError
