# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import Toggles.RoutingLibToggleLib
# pkgdeps: rpm RoutingLib

# Get adjType enum values from TAC model instead of hardcoding them
if Toggles.RoutingLibToggleLib.toggleFibGenMountPathEnabled():
   adjTypeV4 = Tac.enumValue( 'Smash::Fib::AdjType', 'fibGenAdj' )
   adjTypeV6 = Tac.enumValue( 'Smash::Fib::AdjType', 'fibGenAdj' )
   adjTypeUsedByTunnelV4 = Tac.enumValue( 'Smash::Fib::AdjType',
                                          'usedByTunnelGenAdj' )
   adjTypeUsedByTunnelV6 = Tac.enumValue( 'Smash::Fib::AdjType',
                                          'usedByTunnelGenAdj' )
else:
   adjTypeV4 = Tac.enumValue( 'Smash::Fib::AdjType', 'fibV4Adj' )
   adjTypeV6 = Tac.enumValue( 'Smash::Fib::AdjType', 'fibV6Adj' )
   adjTypeUsedByTunnelV4 = Tac.enumValue( 'Smash::Fib::AdjType',
                                          'usedByTunnelV4Adj' )
   adjTypeUsedByTunnelV6 = Tac.enumValue( 'Smash::Fib::AdjType',
                                          'usedByTunnelV6Adj' )

adjTypeResilientEcmp = Tac.enumValue( 'Smash::Fib::AdjType', 'resilientEcmpAdj' )
adjTypeNextHopGroup = Tac.enumValue( 'Smash::Fib::AdjType', 'nextHopGroupAdj' )
adjTypeAttached = Tac.enumValue( 'Smash::Fib::AdjType', 'attachedAdj' )
adjTypeMplsTunnel = Tac.enumValue( 'Smash::Fib::AdjType', 'tunnelFibAdj' )
adjTypeEvpnGen = Tac.enumValue( 'Smash::Fib::AdjType', 'evpnGenAdj' )
adjTypeFloodSet = Tac.enumValue( 'Smash::Fib::AdjType', 'floodSetAdj' )
adjTypePwLocal = Tac.enumValue( 'Smash::Fib::AdjType', 'pwLocalAdj' )
adjTypePwDecap = Tac.enumValue( 'Smash::Fib::AdjType', 'pwDecapAdj' )
adjTypeSrTePolicyFec = Tac.enumValue( 'Smash::Fib::AdjType', 'srTePolicyAdj' )
adjTypeL2NexthopGroup = Tac.enumValue( 'Smash::Fib::AdjType', 'l2NexthopGroupAdj' )
adjTypeNexthop = Tac.enumValue( 'Smash::Fib::AdjType', 'nexthopAdj' )
adjTypeMax = Tac.enumValue( 'Smash::Fib::AdjType', 'adjTypeMax' )

# Get adjType bit fields from TAC model instead of hardcoding them
tacFecIfAdjConstType = Tac.Type( 'Smash::Fib::FecIdAdjConstants' )
adjTypePos = tacFecIfAdjConstType.typePos
adjIndexMask = tacFecIfAdjConstType.indexMask
adjTypeMask = tacFecIfAdjConstType.typeMask

# Get fec Id enum values from TAC model instead of hardcoding them
fecIdInvalid = Tac.enumValue( 'Smash::Fib::FecIdConstants', 'invalidFecId' )
fecIdIpv4Drop = Tac.enumValue( 'Smash::Fib::FecIdConstants', 'ipv4DropFecId' )
fecIdIpv6Drop = Tac.enumValue( 'Smash::Fib::FecIdConstants', 'ipv6DropFecId' )
fecIdConstantMax = Tac.enumValue( 'Smash::Fib::FecIdConstants',
                                  'minNonReservedFecIndex' )

# These constants are not synced to any TAC models
fecIdToIntfIdIndexMask = 0x000000FFFFFFFFFF
fecIdToIntfIdIndexPos = 40
