# Copyright (c) 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import os
import re

import CEosHelper

def abootFirmwareRev():
   """Obtain the Aboot version"""
   # First check if we are running in a workspace
   etcDir = os.environ.get( "VERSION_ETC_DIR", "/etc" )
   if ( not os.path.exists( os.path.join( etcDir, "arch" ) ) ) or\
      ( not os.path.exists( os.path.join( etcDir, "swi-version" ) ) ):
      return "unknown (in workspace)"
   if CEosHelper.isCeos():
      return "not applicable (cEOS doesn't use Aboot)"
   # Read from Aboot command line
   with open( '/proc/cmdline' ) as cmdLineFile:
      m = re.search( r"Aboot=(\S+)", cmdLineFile.read() )
   return m.group( 1 ) if m else ""

def abootFirmwareRevNumbers():
   rev = abootFirmwareRev()
   if 'unknown' in rev:
      return ""
   # The rev is of the form 'Aboot-norcal1-1.9.8'. However, I am being more
   # tolerant and will accept the first instance of num.num[ .num... ] that I see.
   match = re.search( r"(\d+\.\d+[\d|\.]*)", rev )
   return match.group() if match else ""
