# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac

sampleRate = Tac.Type( "FlowTracking::SampleRate" )
sampleLimit = Tac.Type( "FlowTracking::SampleLimit" )
activeInterval = Tac.Type( "FlowTracking::ActiveInterval" )
inactiveTimeout = Tac.Type( "FlowTracking::InactiveTimeout" )
flowTableSize = Tac.Type( "FlowTracking::FlowTableSize" )
ipfixVersion = Tac.Type( "FlowTracking::IpfixVersion" )
ipfixMtu = Tac.Type( "FlowTracking::IpfixMtu" )
ipfixPort = Tac.Type( "Ipfix::L4Port" )
templateInterval = Tac.Type( "FlowTracking::TemplateInterval" )
constants = Tac.newInstance( "FlowTracking::Constants" )
ftId = Tac.Type( "FlowTracking::FtId" )
accessListDefault = Tac.Value( "FlowTracking::AccessList" )
mirrorConfigDefault = Tac.Value( "FlowTracking::MirrorConfig" )
initialCopy = Tac.Type("FlowTracking::InitialCopy" )
mirrorIntervalFixed = Tac.Type("FlowTracking::MirrorIntervalFixed" )
mirrorIntervalRandom = Tac.Type("FlowTracking::MirrorIntervalRandom" )
mirrorSelectorAlgo = Tac.Type("FlowTracking::MirrorSelectorAlgo")
reservedGroupNames = Tac.newInstance( "FlowTracking::ReservedGroupNames" )
hoHeuristicsConstants = Tac.Type( "FlowTracking::HoHeuristicsConstants" )
congestionInterval = Tac.Type( "FlowTracking::CongestionInterval" )
dampingTimeout = Tac.Type( "FlowTracking::DampingTimeout" )

spaceConst = '   '

# Printing helper method for outputing "(Default)" next
# to a value that matches the default value
def valueWithDefaultInd( value, default ):
   if value == default:
      return "%s (default)" % value
   else:
      return "%s" % value
