# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Fru
import Tac
import Tracing

__defaultTraceHandle__ = Tracing.Handle( "Fru.Capabilities" )
t0 = Tracing.trace0

class CapabilitiesDriver( Fru.FruDriver ):
   provides = [ 'L1Capabilities' ]
   requires = [ Fru.FruDriver.interfaceInit ]

   managedTypeName = "Inventory::Capabilities::InvEthPortCapRestrictionsDir"
   managedApiRe = "$"

   def __init__( self, invDir, parentMib, parentDriver, driverCtx ):
      Fru.FruDriver.__init__( self, invDir, parentMib,
                              parentDriver, driverCtx )
      t0( "Handling %s for %s" % # pylint: disable=consider-using-f-string
          ( self.managedTypeName, Fru.fruBaseName( invDir ) ) )
      l1CapDir = driverCtx.entity( 'hardware/l1/fru/capabilities/slice' )
      fruBaseName = Fru.fruBaseName( invDir )
      capSliceDir = l1CapDir.newEntity( "Tac::Dir", fruBaseName )

      fdlCapDir = Fru.Dep(
         capSliceDir, invDir ).newEntity(
         "Hardware::Capabilities::HwCapRestrictionsDir", "fdlCaps" )

      for ethPortId, invPortCaps in invDir.ethPortCapEnforced.items():
         assert invPortCaps.port
         if not invPortCaps.port.bound:
            continue
         intfId = invPortCaps.port.intfId
         assert invPortCaps.port.id == ethPortId
         fdlCapDir.newIntfCapEnforced( intfId,
                                       invPortCaps.intfCapsEnforced,
                                       invPortCaps.enforcedAction )

def Plugin( context ):
   """Register the plugins."""
   context.registerDriver( CapabilitiesDriver )

   mg = context.entityManager.mountGroup()
   mg.mount( 'hardware/l1/fru/capabilities/slice', 'Tac::Dir', 'wi' )
   mg.close( None )
