#!/usr/bin/env python3
# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable-msg=F0401
# pylint: disable-msg=W0232

# pylint: disable-next=consider-using-from-import
import FruPlugin.PmbusPowerSupply as PmbusPowerSupply
from PmbusConstants import dsPedPowerLossValues
from PmbusConstants import aristaPowerLossValues

ARISTA_MFR_DATA = PmbusPowerSupply.ARISTA_MFR_DATA

class LassenDriver( PmbusPowerSupply.PmbusV11Driver ):
   managedTypeName = "Inventory::PowerSupply::PowerSupplyFru"
   managedApiRe = "DeltaLassen$"

   # m, b, and R coefficients don't matter because these supplies
   # use linear encoding for everything.
   directM = 0
   directB = 0
   directR = 0
   tempSensorEncoding = "pmbusEncodingLinear11"
   fanCommandEncoding = "pmbusEncodingLinear11"
   readFanSpeedEncoding = "pmbusEncodingLinear11"
   inputVoltageEncoding = "pmbusEncodingLinear11"
   inputCurrentEncoding = "pmbusEncodingLinear11"
   inputPowerEncoding = "pmbusEncodingLinear11"
   outputCurrentEncoding = "pmbusEncodingLinear11"
   outputPowerEncoding = "pmbusEncodingLinear11"
   overTempEncoding = "pmbusEncodingLinear11"
   outputCurrentCanSignalFailure = False
   extraDelays = False
   sendByteSupported = True
   powerLossValues = dsPedPowerLossValues
   fanWarningsLenient = True
   overTempLenientDelay = 0

class LassenFanOperationDriver( LassenDriver ):
   managedApiRe = "DeltaLassenFanOperation$"

   fanOperation = True

class LassenPecDriver( LassenDriver ):
   managedApiRe = "DeltaLassenPec$"

   pec = True

class LassenPecDualFanDriver( LassenPecDriver ):
   managedApiRe = "DeltaLassenPecDualFan$"

   dualFan = True

class LassenFirmwareI2cBlockRead( LassenPecDriver ):
   managedApiRe = "DeltaLassenFirmwareI2cBlockRead$"

   mfrData = [
      ( "MFR_ID", 0x99, None ),
      ( "MFR_MODEL", 0x9a, None ),
      ( "MFR_REVISION", 0x9b, None ),
      ( "MFR_SERIAL", 0x9e, None ),
      ( "PRI_FIRMWARE", 0xe0, 8 ),
      ( "SEC_FIRMWARE", 0xe1, 8 ),
   ]

class Sager700Driver( LassenDriver ):
   managedApiRe = "Sager700$"

   bug602296 = True

class LiteOn2400HvDriver( LassenDriver ):
   managedApiRe = "LiteOn2400Hv$"

   mfrData = [
      ( "MFR_ID", 0x99, None ),
      ( "MFR_MODEL", 0x9a, None ),
      ( "MFR_REVISION", 0x9b, None ),
      ( "MFR_SERIAL", 0x9e, None ),
      ( "FW_REVISION", 0xd5, 8 ),
   ]

class SenaoEma1800DaDriver( LassenDriver ):
   managedApiRe = "SenaoEma1800Da$"

   pec = True

class ApdNw1800A01Driver( LassenDriver ):
   managedApiRe = "ApdNw1800A01$"

   mfrData = [
      ( "MFR_ID", 0x99, None ),
      ( "MFR_MODEL", 0x9a, None ),
      ( "MFR_REVISION", 0x9b, None ),
      ( "MFR_SERIAL", 0x9e, None ),
   ]
   pec = True

class FspDriver( LassenDriver ):
   managedApiRe = "FspDriver$"

   mfrData = [
      ( "MFR_ID", 0x99, None ),
      ( "MFR_MODEL", 0x9a, None ),
      ( "MFR_REVISION", 0x9b, None ),
      ( "MFR_SERIAL", 0x9e, None ),
      ( "FW_REVISION", 0xed, None ),
   ]

class AristaDriver( LassenDriver ):
   managedApiRe = "Arista$"

   mfrData = [
      *ARISTA_MFR_DATA,
      ( "PRI_FIRMWARE", 0xe0, None ),
      ( "SEC_FIRMWARE", 0xe1, None )
   ]

   powerLossValues = aristaPowerLossValues
   powerGoodFaultFailed = True

def Plugin( ctx ):
   ctx.registerDriver( LassenDriver )
   ctx.registerDriver( LassenFanOperationDriver )
   ctx.registerDriver( LassenPecDriver )
   ctx.registerDriver( LassenPecDualFanDriver )
   ctx.registerDriver( LassenFirmwareI2cBlockRead )
   ctx.registerDriver( Sager700Driver )
   ctx.registerDriver( LiteOn2400HvDriver )
   ctx.registerDriver( SenaoEma1800DaDriver )
   ctx.registerDriver( ApdNw1800A01Driver )
   ctx.registerDriver( FspDriver )
   ctx.registerDriver( AristaDriver )

   mg = ctx.entityManager.mountGroup()
   mg.mount( 'hardware/powerSupply/pmbus11',
             'Hardware::PowerSupply::Pmbus::Config', 'w' )
   mg.close( None )
