#!/usr/bin/env python3
# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Cell
import Fru
import Tracing

__defaultTraceHandle__ = Tracing.Handle( 'InternalIntfSlot' )

t0 = Tracing.trace0

class InternalIntfSlotDirDriver( Fru.FruDriver ):
   managedTypeName = 'Inventory::IntfSlot::SlotDir'

   def __init__( self, invDir, parentMib, parentDriver, driverCtx ):
      super().__init__( invDir, parentMib,
                        parentDriver, driverCtx )
      slotId = Fru.fruBase( invDir ).sliceId
      if not slotId:
         assert Cell.cellType() == 'fixed'
         slotId = 'FixedSystem'

      t0( f'Handling {self.managedTypeName} for {slotId}' )

      slot = driverCtx.entity( 'hardware/l1/intfSlot/spec/slot' )
      slotIdDir = Fru.Dep( slot, invDir ).newEntity(
            'Interface::SubdomainIntfSlotHwSpecDir',
            slotId )
      for ( slotName, slotInv ) in invDir.slot.items():
         hwSpec = slotIdDir.newSubdomainIntfSlotHwSpec( slotName )
         hwSpec.defaultIntfPresence = slotInv.defaultIntfPresence
         hwSpec.intfSlotType = slotInv.intfSlotType
         hwSpec.hwIntfSlotType = slotInv.hwIntfSlotType
         hwSpec.medium = slotInv.medium
         for ( laneId, intfName ) in slotInv.slotLaneToIntfName.items():
            hwSpec.slotLaneToIntfName[ laneId ] = intfName

def Plugin( context ):
   context.registerDriver( InternalIntfSlotDirDriver )

   mg = context.entityManager.mountGroup()
   mg.mount( 'hardware/l1/intfSlot/spec/slot', 'Tac::Dir', 'wi' )
   mg.close( None )
