#!/usr/bin/env python3
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Fru
import Tac

class LedPolicyDriver( Fru.FruDriver ):
   managedTypeName = "Inventory::LedSystemDir"
   provides = [ 'ledInit' ]

   def __init__( self, invLedSystemDir, parentMibEnt, parentDriver, ctx ):
      Fru.FruDriver.__init__( self, invLedSystemDir, parentMibEnt, parentDriver,
                              ctx )
      hwLedConfigInit = ctx.sysdbRoot[ 'hardware' ][ 'led' ][ 'configInit' ]

      # First copy over the LEDs
      for ledName, invLed in invLedSystemDir.leds.items():
         ledConfig = Fru.Dep( hwLedConfigInit.leds,
                              invLedSystemDir ).newMember( ledName, ledName )
         for stateName in invLed.state:
            if stateName not in ledConfig.state:
               ledConfig.newState( stateName, invLed.state[ stateName ].available )
         ledConfig.theme = invLed.theme

      # Then copy over default 'palette' values
      if invLedSystemDir.palette:
         hwLedConfigInit.palette = ( invLedSystemDir.palette.name, )
         for ledCapability in invLedSystemDir.palette.ledCapability.values():
            ledName = ledCapability.name
            ledCap = hwLedConfigInit.palette.newLedCapability( ledName )

            for lightSetting in ledCapability.lightSetting.values():
               ledCap.lightSetting[ lightSetting.color ] = \
                           Tac.Value( "Led::LightSetting",
                                      color=lightSetting.color,
                                      ledFlashRate=lightSetting.ledFlashRate )

            ledCap.master = ledCapability.master
            for status in ledCapability.associatedLed:
               associatedLed = ledCap.newAssociatedLed( status )
               for led in ledCapability.associatedLed[ status ].led:
                  associatedLed.led[ led ] = True

      # Finally, copy over the default 'theme' values
      if invLedSystemDir.theme:
         for themeName in invLedSystemDir.theme:
            theme = hwLedConfigInit.newTheme( themeName )
            for stateName in invLedSystemDir.theme[ themeName ].setting:
               themeSetting = theme.newSetting( stateName )
               themeSetting.value = \
                     invLedSystemDir.theme[ themeName ].setting[ stateName ].value

def Plugin( ctx ):
   ctx.registerDriver( LedPolicyDriver )

   mg = ctx.entityManager.mountGroup()
   mg.mount( "hardware/led/configInit", "Hardware::Led::LedSystemConfigDir", "w" )
   mg.close( None )
