#!/usr/bin/env python3
# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Fru
import Tracing
import Tac

__defaultTraceHandle__ = Tracing.Handle( "Fru.PlutoSmbus" )
t0 = Tracing.trace0

class PlatformSmbusDriver( Fru.FruDriver ):

   managedTypeName = "Inventory::Smbus::PlatformSmbus"

   def __init__( self, platformSmbus, parentMibEntity, parentDriver, driverCtx ):
      Fru.FruDriver.__init__( self, platformSmbus, parentMibEntity, parentDriver,
                              driverCtx )
      sysdbRoot = driverCtx.sysdbRoot
      hwSmbus = Fru.newStyleHardwareDir( sysdbRoot[ 'hardware' ][ 'smbus' ],
                                         'Hardware::SmbusEngine',
                                         platformSmbus )
      hwSmbus.agentId = 0xFF
      hwSmbus.engineGenerationId = Tac.Value( "Ark::Generation",
                                              Fru.powerGenerationId( platformSmbus ),
                                              True )

def Plugin( context ):
   context.registerDriver( PlatformSmbusDriver )

   mg = context.entityManager.mountGroup()
   mg.mount( 'hardware/smbus', 'Tac::Dir', 'wi' )
   mg.close( None )
