# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Fru
import Logging

FRU_SYSTEM_IMAGE_RESTRICTION_2GB = Logging.LogHandle(
              "FRU_SYSTEM_IMAGE_RESTRICTION_2GB",
              severity=Logging.logEmergency,
              fmt="%s is only supported in 2GB images. Please remove "
              "the current EOS image from /mnt/flash and upgrade to a "
              "2GB image such as EOS-2GB.swi, EOS-2GB-PDP.swi, etc",
              explanation="This system is not supported in the loaded "
              "EOS image and system functionality is severely limited.",
              recommendedAction="Remove the current EOS image from /mnt/flash "
              "and upgrade to a 2GB image" )

class RestrictedFruDriver( Fru.FruDriver ):

   managedTypeName = "Eos::RestrictedFru"

   def __init__( self, testFru, parentMibEntity, parentDriver, driverCtx ):
      Fru.FruDriver.__init__( self, testFru, parentMibEntity, parentDriver,
                              driverCtx )
      if testFru.restrictionType == "restricted2GBFru":
         Logging.log( FRU_SYSTEM_IMAGE_RESTRICTION_2GB, parentMibEntity.modelName )
      else:
         assert False, "Fru is restricted with unknown restriction type"

def Plugin( context ):
   context.registerDriver( RestrictedFruDriver )

