#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import EntityMib
from EntityMib import ChipType, IndexAllocator
import Tracing

__defaultTraceHandle__ = Tracing.Handle( "Fru.Vrm" )
t0 = Tracing.trace0

MAX_CHIPS_PER_SLICE = 100

modelsToOffsets = {
   'Isl6812X': 0,
   'Ir35X': 100,
   'Chl822X': 200,
   'Pol': 300,
}

def vrmChipId( vrmModel, existingIds ):
   t0( f'Generating chipId for vrm model: {vrmModel}, ' \
       f'existingIds: {list( existingIds) }.' )
   assert vrmModel in modelsToOffsets, 'invalid vrmModel'

   offset = modelsToOffsets[ vrmModel ]
   for nextLocalId in range( MAX_CHIPS_PER_SLICE ):
      chipId = IndexAllocator.getChipId( ChipType.vrm, offset + nextLocalId )
      if chipId not in existingIds:
         t0( f'Generated chipId: {chipId}' )
         return chipId
   
   raise EntityMib.MaxChipIdError( f'Max num of {vrmModel} chipIds of exceeded '
                                   f'{MAX_CHIPS_PER_SLICE}' )