#!/usr/bin/env python3
# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from EoamTypes import (
   tacRateUnit,
   FeatureEnabledEnum,
)
from TypeFuture import TacLazyType

generatorTypeKwLinkQualification = "link qualification"
generatorTypeKwRFC2544 = "rfc2544"
generatorTypeShowKwLinkQualification = "Link qualification"
generatorTypeShowKwRFC2544 = "RFC2544"
# Used in the CLI config prompt
generatorTypePromptStr = {
   generatorTypeKwLinkQualification : "lq",
   generatorTypeKwRFC2544 : "2544"
}
generatorDirectionEnum = TacLazyType( "FlowGenerator::FlowDirection" )
generatorDirectionKwStr = {
   generatorDirectionEnum.flowIn : "in",
   generatorDirectionEnum.flowOut : "out",
}
featureEnabledEnumToCliKwMap = {
   FeatureEnabledEnum.linkQualification : generatorTypeKwLinkQualification,
   FeatureEnabledEnum.rfc2544 : generatorTypeKwRFC2544
}
featureEnabledEnumToShowKwMap = {
   FeatureEnabledEnum.linkQualification : generatorTypeShowKwLinkQualification,
   FeatureEnabledEnum.rfc2544 : generatorTypeShowKwRFC2544
}
generatorDirectionShowStr = {
   generatorDirectionEnum.flowIn : "in",
   generatorDirectionEnum.flowOut : "out",
   generatorDirectionEnum.flowDirectionUnknown : "none",
}
packetRateShowStr = {
   tacRateUnit.rateUnitbps : 'bps',
   tacRateUnit.rateUnitKbps : 'Kbps',
   tacRateUnit.rateUnitMbps : 'Mbps',
   tacRateUnit.rateUnitGbps : 'Gbps'
}
